<?php
class DTE_DiviTestimonialExtended extends DiviExtension {

	/**
	 * The gettext domain for the extension's translations.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $gettext_domain = 'divi-testimonial-extended';

	/**
	 * The extension's WP Plugin name.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $name = 'divi-testimonial-extended';

	/**
	 * The extension's version
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $version = ELICUS_TESTIMONIAL_VERSION;

	/**
	 * DiviTestimonialExtended constructor.
	 *
	 * @param string $name
	 * @param array  $args
	 */
	public function __construct( $name = 'divi-testimonial-extended', $args = array() ) {
		$this->plugin_dir     = plugin_dir_path( __FILE__ );
		$this->plugin_dir_url = plugin_dir_url( $this->plugin_dir );

		$this->_frontend_js_data = array(
            'ajaxurl'   => admin_url( 'admin-ajax.php' ),
            'ajaxnonce' => wp_create_nonce( 'elicus-divi-testimonial-extended-nonce' ),
        );
		
		parent::__construct( $name, $args );

		$this->el_testimonial_register_post_type();
		$this->el_testimonial_register_taxonomies();

		if ( is_admin() ) {
			require_once plugin_dir_path( __FILE__ ) . 'src/class-update.php';
		}
		
		add_action( 'load-post.php',  array( $this, 'el_testimonial_add_meta_boxes' ) );
        add_action( 'load-post-new.php',  array( $this, 'el_testimonial_add_meta_boxes' ) );
        add_action( 'save_post', array( $this, 'el_save_testimonial_meta_fields' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'el_testimonial_admin_styles' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'el_testimonial_register_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'el_testimonial_fb_enqueue_scripts' ) );
		add_filter( 'sanitize_post_meta_testimonial_rating', array( $this, 'el_sanitize_testimonial_rating_meta' ) );
		add_action( 'init', array( $this, 'el_testimonial_load_plugin_textdomain' ) );
		add_action( 'wp_ajax_el_get_testimonials', array( $this, 'el_get_testimonials' ) );
        add_action( 'wp_ajax_nopriv_el_get_testimonials', array( $this, 'el_get_testimonials' ) );
	}

	public function el_testimonial_register_post_type() {
		$labels = array(
			'name'               => esc_html__( 'Testimonials', 'divi-testimonial-extended' ),
			'singular_name'      => esc_html__( 'Testimonial', 'divi-testimonial-extended' ),
			'add_new'            => esc_html__( 'Add New', 'divi-testimonial-extended' ),
			'add_new_item'       => esc_html__( 'Add New Testimonial', 'divi-testimonial-extended' ),
			'edit_item'          => esc_html__( 'Edit Testimonial', 'divi-testimonial-extended' ),
			'new_item'           => esc_html__( 'New Testimonial', 'divi-testimonial-extended' ),
			'view_item'          => esc_html__( 'View Testimonial', 'divi-testimonial-extended' ),
			'search_items'       => esc_html__( 'Search Testimonials', 'divi-testimonial-extended' ),
			'not_found'          => esc_html__( 'No testimonials found', 'divi-testimonial-extended' ),
			'not_found_in_trash' => esc_html__( 'No testimonials found in Trash', 'divi-testimonial-extended' ),
			'parent_item_colon'  => esc_html__( 'Parent Testimonial:', 'divi-testimonial-extended' ),
			'menu_name'          => esc_html__( 'Testimonials', 'divi-testimonial-extended' ),
		);

		$args = array(
			'labels'            => $labels,
			'hierarchical'      => true,
			'description'       => esc_html__( 'Testimonials filterable by category', 'divi-testimonial-extended' ),
			'supports'          => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'revisions' ),
			'taxonomies'        => array( 'testimonial_category' ),
			'menu_position'     => 58,
			'menu_icon'         => 'dashicons-format-quote',
			'public'            => true,
			'show_ui'           => true,
			'show_in_menu'      => true,
			'show_in_nav_menus' => true,
			'has_archive'       => true,
			'query_var'         => true,
			'capability_type'   => 'post',
		);

		register_post_type( 'testimonials', $args );
	}

	public function el_testimonial_register_taxonomies() {
		$labels = array(
            'name'                       => esc_html_x( 'Testimonial Categories', 'Taxonomy General Name', 'divi-testimonial-extended' ),
            'singular_name'              => esc_html_x( 'Testimonial Category', 'Taxonomy Singular Name', 'divi-testimonial-extended' ),
            'menu_name'                  => esc_html__( 'Testimonial Categories', 'divi-testimonial-extended' ),
            'all_items'                  => esc_html__( 'All Testimonial Categories', 'divi-testimonial-extended' ),
            'parent_item'                => esc_html__( 'Parent Testimonial Category', 'divi-testimonial-extended' ),
            'parent_item_colon'          => esc_html__( 'Parent Testimonial Category:', 'divi-testimonial-extended' ),
            'new_item_name'              => esc_html__( 'New Testimonial Category Name', 'divi-testimonial-extended' ),
            'add_new_item'               => esc_html__( 'Add New Testimonial Category', 'divi-testimonial-extended' ),
            'edit_item'                  => esc_html__( 'Edit Testimonial Category', 'divi-testimonial-extended' ),
            'update_item'                => esc_html__( 'Update Testimonial Category', 'divi-testimonial-extended' ),
            'view_item'                  => esc_html__( 'View Testimonial Category', 'divi-testimonial-extended' ),
            'separate_items_with_commas' => esc_html__( 'Separate categories with commas', 'divi-testimonial-extended' ),
            'add_or_remove_items'        => esc_html__( 'Add or remove categories', 'divi-testimonial-extended' ),
            'choose_from_most_used'      => esc_html__( 'Choose from the most used', 'divi-testimonial-extended' ),
            'popular_items'              => esc_html__( 'Popular Testimonial Categories', 'divi-testimonial-extended' ),
            'search_items'               => esc_html__( 'Search Testimonial Categories', 'divi-testimonial-extended' ),
            'not_found'                  => esc_html__( 'Not Found', 'divi-testimonial-extended' ),
            'no_terms'                   => esc_html__( 'No Testimonial Categories', 'divi-testimonial-extended' ),
            'items_list'                 => esc_html__( 'Testimonial Categories list', 'divi-testimonial-extended' ),
            'items_list_navigation'      => esc_html__( 'Testimonial Categories list navigation', 'divi-testimonial-extended' ),
        );

        $args = array(
            'labels'                     => $labels,
            'hierarchical'               => true,
            'public'                     => true,
            'show_ui'                    => true,
            'show_admin_column'          => true,
            'show_in_nav_menus'          => true,
            'show_tagcloud'              => true,
            'rewrite'           		 => array(
				'slug'       => 'testimonial-category',
				'with_front' => false,
			),
        );

        register_taxonomy( 'testimonial_category', array( 'testimonials' ), $args );
	}

	public function el_testimonial_add_meta_boxes() {
		add_action( 'add_meta_boxes', array( $this, 'el_testimonial_meta_boxes' ) );
	}

	public function el_testimonial_meta_boxes() {
		add_meta_box( 'el-testimonial-box', esc_html__( 'Divi Testimonial Extended Form Values', 'divi-testimonial-extended' ),array( $this, 'el_testimonial_metabox_callback' ), 'testimonials', 'normal', 'high' );
	}

	public function el_testimonial_metabox_callback( $post ) {
		$values      = get_post_custom( $post->ID );
		$name        = isset( $values['testimonial_meta_box-name'] ) ? $values['testimonial_meta_box-name'][0] : '';
		$email       = isset( $values['testimonial_meta_box-email'] ) ? $values['testimonial_meta_box-email'][0] : '';
		$designation = isset( $values['testimonial_meta_box-designation'] ) ? $values['testimonial_meta_box-designation'][0] : '';
		$company     = isset( $values['testimonial_meta_box-company'] ) ? $values['testimonial_meta_box-company'][0] : '';
		$rating      = isset( $values['testimonial_meta_box-rating'] ) ? $values['testimonial_meta_box-rating'][0] : '';
		$url         = isset( $values['testimonial_meta_box-company_url'] ) ? $values['testimonial_meta_box-company_url'][0] : '';
		$rating      = $rating ? $rating : '5';
		
		wp_nonce_field( 'testimonial_meta_box_nonce', 'testimonial_meta_box_nonce' );
		?>
		<p class="dte-option-setting">
			<label for="testimonial_meta_box-name"><?php esc_html_e( 'Author Name:', 'divi-testimonial-extended' ); ?></label>
			<input type="text" name="testimonial_meta_box-name" id="testimonial_meta_box-name" value="<?php echo esc_attr( $name ); ?>" />
		</p>
		<p class="dte-option-setting">
			<label for="testimonial_meta_box-email"><?php esc_html_e( 'Author Email:', 'divi-testimonial-extended' ); ?></label>
			<input type="text" name="testimonial_meta_box-email" id="testimonial_meta_box-email" value="<?php echo esc_attr( $email ); ?>" />
		</p>
		<p class="dte-option-setting">
			<label for="testimonial_meta_box-designation"><?php esc_html_e( 'Designation:', 'divi-testimonial-extended' ); ?></label>
			<input type="text" name="testimonial_meta_box-designation" id="testimonial_meta_box-designation" value="<?php echo esc_attr( $designation ); ?>" />
		</p>
		<p class="dte-option-setting">
			<label for="testimonial_meta_box-company"><?php esc_html_e( 'Company:', 'divi-testimonial-extended' ); ?></label>
			<input type="text" name="testimonial_meta_box-company" id="testimonial_meta_box-company" value="<?php echo esc_attr( $company ); ?>" />
		</p>
		<p class="dte-option-setting">
			<label for="testimonial_meta_box-company_url"><?php esc_html_e( 'URL:', 'divi-testimonial-extended' ); ?></label>
			<input type="text" name="testimonial_meta_box-company_url" id="testimonial_meta_box-company_url" value="<?php echo esc_attr( $url ); ?>" />
		</p>
		<p class="dte-option-setting">
			<label for="testimonial_meta_box-rating"><?php esc_html_e( 'Rating:', 'divi-testimonial-extended' ); ?></label>
			<select name="testimonial_meta_box-rating" id="testimonial_meta_box-rating">
				<option value="0" <?php selected( esc_attr( $rating ), '0' ); ?>>Select Rating</option>
				<option value="1" <?php selected( esc_attr( $rating ), '1' ); ?>>1</option>
				<option value="2" <?php selected( esc_attr( $rating ), '2' ); ?>>2</option>
				<option value="3" <?php selected( esc_attr( $rating ), '3' ); ?>>3</option>
				<option value="4" <?php selected( esc_attr( $rating ), '4' ); ?>>4</option>
				<option value="5" <?php selected( esc_attr( $rating ), '5' ); ?>>5</option>
			</select>
		</p>
		<?php
	}

	public function el_save_testimonial_meta_fields( $post_id ) {
		// doing an auto save.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// verify nonce.
		if ( ! isset( $_POST['testimonial_meta_box_nonce'] ) || ! wp_verify_nonce( sanitize_key( wp_unslash( $_POST['testimonial_meta_box_nonce'] ) ), 'testimonial_meta_box_nonce' ) ) {
			return;
		}

		// if current user can not edit the post.
		if ( ! current_user_can( 'edit_posts' ) ) {
			return;
		}

		$fields = array(
			'testimonial_meta_box-name',
			'testimonial_meta_box-email',
			'testimonial_meta_box-designation',
			'testimonial_meta_box-company',
			'testimonial_meta_box-company_url',
			'testimonial_meta_box-rating',
		);

		foreach ( $fields as $field ) {
			if ( isset( $_POST[ $field ] ) ) {
				if ( 'testimonial_meta_box-rating' === $field ) {
					// Sanitize Testimonial Rating & validated values of rating, Filtered in DiviTestimonialExtended.php file.
					${$field} = sanitize_meta( 'testimonial_rating', wp_unslash( $_POST[ $field ] ), 'post' );
				} else {
					${$field} = sanitize_text_field( wp_unslash( $_POST[ $field ] ) );
				}
				update_post_meta( $post_id, esc_attr( $field ), ${$field} );
			}
		}
	}

	public function el_testimonial_admin_styles( $hook_suffix ) {
		if ( $hook_suffix === 'post-new.php' || $hook_suffix === 'post.php' ) {
			wp_enqueue_style( 'el-testimonial-admin-style', "{$this->plugin_dir_url}styles/admin/admin.min.css", array(), $this->version );
		}
	}

	public function el_testimonial_register_scripts() {
		wp_register_script( 'elicus-images-loaded-script', "{$this->plugin_dir_url}scripts/imagesloaded.pkgd.min.js", array('jquery'), '4.1.4', true );
        wp_register_script( 'elicus-isotope-script', "{$this->plugin_dir_url}scripts/isotope/isotope.pkgd.min.js", array('jquery'), '3.0.6', true );
        wp_register_script( 'el-testimonial-form-script', "{$this->plugin_dir_url}scripts/el-testimonial-form.min.js", array('jquery'), $this->version, false );
        wp_register_script( 'elicus-swiper-script', "{$this->plugin_dir_url}scripts/swiper/swiper.min.js", array('jquery'), '6.4.5', true );
        wp_localize_script( 'el-testimonial-form-script', 'el_ajax_object', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ), 'el_ajax_nonce' => wp_create_nonce( 'elicus-testimonial-nonce' ), ) );
        wp_register_script( 'elicus-twbs-pagination', "{$this->plugin_dir_url}scripts/twbsPagination.min.js", array('jquery'), '1.4.2', true );
        wp_register_style( 'elicus-swiper-style', "{$this->plugin_dir_url}styles/swiper/swiper.min.css", array(), '6.4.5', false );
    }

    public function el_testimonial_fb_enqueue_scripts() {
        if ( et_core_is_fb_enabled() ) {
			wp_enqueue_script( 'elicus-images-loaded-script' );
            wp_enqueue_script( 'elicus-isotope-script' );
            wp_enqueue_script( 'elicus-swiper-script' );
            wp_enqueue_script( 'elicus-twbs-pagination' );
            wp_enqueue_style( 'elicus-swiper-style' );
        }
    }

    public function el_testimonial_load_plugin_textdomain() {
        load_plugin_textdomain( 'divi-testimonial-extended', false, dirname( plugin_basename( __DIR__ ) ) . '/languages/' );
    }

	public function el_sanitize_testimonial_rating_meta( $rating ) {
		$rating        = sanitize_text_field( $rating );
		$valid_ratings = array(
			'0',
			'1',
			'2',
			'3',
			'4',
			'5',
		);

		if ( ! in_array( $rating, $valid_ratings, true ) ) {
			wp_die( 'Invalid rating value.' );
		}

		return $rating;
	}

	public function el_get_testimonials() {
		if ( ! isset( $_POST['testimonial_extended_nonce'] ) || ! wp_verify_nonce( sanitize_key( wp_unslash( $_POST['testimonial_extended_nonce'] ) ), 'elicus-divi-testimonial-extended-nonce' ) ) {
            return;
        }

        if ( ! isset( $_POST['props'] ) ) {
            return;
        }

        $defaults = array(
        	'testimonial_layout' => 'layout1',
        	'use_masonry' => 'off',
        	'number_of_columns' => '2',
            'testimonial_number' => 10,
			'include_categories' => '',
			'testimonial_order_by' => 'date',
			'testimonial_order' => 'DESC',
			'testimonial_offset' => 0,
			'exclude_post_ids'	=> '',
			'show_author_image' => 'on',
			'author_image_layout' => 'rounded',
			'use_gravatar' => 'off',
			'show_author_designation' => 'on',
			'show_author_company_name' => 'on',
			'show_quote_icon' => 'on',
			'show_quote_icon_closing' => 'off',
			'show_rating' => 'on',
			'custom_position_quote_icon' => 'off',
			'custom_position_quote_icon_closing' => 'off',
			'select_opening_quote_icon' => '',
			'select_closing_quote_icon' => '',
			'quote_icon_position' => 'quote_left',
			'quote_icon_position_closing' => 'quote_right',
			'is_user_logged_in' => '',
			'page' => 1,
            'total_pages' => 1,
        );

        foreach ( $defaults as $key => $default ) {
            // phpcs:ignore ET.Sniffs.ValidatedSanitizedInput.InputNotSanitized
            if ( isset( $_POST['props'][$key] ) && et_()->includes( $_POST['props'][$key], '%' ) ) {
                // phpcs:ignore ET.Sniffs.ValidatedSanitizedInput.InputNotSanitized
                $prepared_value  = preg_replace( '/%([a-f0-9]{2})/', '%_$1', $_POST['props'][$key] );
                ${$key} = preg_replace( '/%_([a-f0-9]{2})/', '%$1', trim( sanitize_text_field( wp_unslash( $prepared_value ) ) ) );
            } else {
                // phpcs:ignore ET.Sniffs.ValidatedSanitizedInput.InputNotSanitized
                ${$key} = trim( sanitize_text_field( wp_unslash( et_()->array_get( $_POST['props'], $key, $default ) ) ) ); 
            }
        }
		
		$number_of_testimonials = ( 0 === $testimonial_number ) ? -1 : (int) $testimonial_number;
		$page               	= absint( $page );
        $testimonial_offset 	= ( $number_of_testimonials * ( $page - 1 ) ) + $testimonial_offset;
        $quote_icon             = '';
		$quote_icon_closing     = '';

		$args = array(
			'post_type'      => 'testimonials',
			'posts_per_page' => $number_of_testimonials,
			'offset'		 => $testimonial_offset,
			'post_status'    => 'publish',
			'orderby'        => $testimonial_order_by,
			'order'          => $testimonial_order,
		);

		if ( 'rating' === $testimonial_order_by ) {
			$args['orderby'] 	= 'meta_value_num';
			$args['meta_key'] 	= 'testimonial_meta_box-rating';
		}

		if ( $is_user_logged_in ) {
			$args['post_status'] = array(
				'publish',
				'private',
			);
		}

		if ( '' !== $include_categories ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'testimonial_category',
					'field'    => 'term_id',
					'terms'    => explode( ',', esc_attr( $include_categories ) ),
					'operator' => 'IN',
				),
			);
		}

		if ( '' !== $exclude_post_ids ) {
			$exclude_post_ids = array_map( 'trim', explode( ',', $exclude_post_ids ) );
			$args['post__not_in'] = array_map( 'intval', $exclude_post_ids );
		}

		$the_query = new WP_Query( $args );

		if ( $the_query->have_posts() ) {
			$testimonials = '';

			if ( 'on' === $show_quote_icon ) {
				$opening_icon_class = ( 'format_quote' === $select_opening_quote_icon ) ? 'el_md_material_opening_icon' : 'el_md_default_opening_icon';
				
				if ( 'off' === $custom_position_quote_icon ) {
					$quote_icon = '<span class="el-quote-opening '.$opening_icon_class.'">'.$select_opening_quote_icon.'</span>';
				} elseif ( 'on' === $custom_position_quote_icon ) {
					$quote_icon = '<span class="el-quote-opening  '.$opening_icon_class.' quote-custom ' . $quote_icon_position . '">'.$select_opening_quote_icon.'</span>';
				} else {
					$quote_icon = '';
				}
			}

			if ( 'on' === $show_quote_icon_closing ) {
				$closing_icon_class = ( 'format_quote' === $select_closing_quote_icon ) ? 'el_md_material_closing_icon' : 'el_md_default_closing_icon';

				if ( 'off' === $custom_position_quote_icon_closing ) {
					$quote_icon_closing = '<span class="el-quote-closing '.$closing_icon_class.'">'.$select_closing_quote_icon.'</span>';
				} elseif ( 'on' === $custom_position_quote_icon_closing ) {
					$quote_icon_closing = '<span class="el-quote-closing '.$closing_icon_class.' quote-custom ' . $quote_icon_position_closing . '">'.$select_closing_quote_icon.'</span>';
				} else {
					$quote_icon_closing = '';
				}
			}


			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$testimonial_id = esc_attr( get_the_ID() );

				/*Get Star Rating*/
				$rating = '';
				$rate = esc_attr( (int) get_post_meta( $testimonial_id, 'testimonial_meta_box-rating', true ) );
				if ( 'on' === $show_rating && 0 !== $rate ) {
					$rating  = '<div class="el-testimonial-rating">';
					$rating .= '<span itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">';
					$rating .= '<span class="rating-value" itemprop="ratingValue">' . $rate . '</span>';
					if ( $rate < 5 ) {
						for ( $i = 1; $i <= $rate; $i++ ) {
							$rating .= '<span class="el-rated"></span>';
						}
						for ( $i = 1; $i <= ( 5 - $rate ); $i++ ) {
							$rating .= '<span class="el-non-rated"></span>';
						}
					} else {
						for ( $i = 1; $i <= $rate; $i++ ) {
							$rating .= '<span class="el-rated"></span>';
						}
					}
					$rating .= '</span>';
					$rating .= '</div>';
				}

				/*Get Author Image*/
				$author_image = '';
				if ( 'on' === $show_author_image ) {
					/* Author Image */
					$featured_image 	= has_post_thumbnail( $testimonial_id );
					$author_image       = '<div class="el-testimonial-portrait '. esc_attr( $author_image_layout ) . '">';
					if ( $featured_image ) {
						$author_image .= get_the_post_thumbnail( $testimonial_id, 'thumbnail' );
					} elseif ( 'on' === $use_gravatar ) {
						$author_email = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-email', true ) );
						if ( $author_email ) {
							$avatar_image_url = esc_attr( get_avatar_url( $author_email ) );
						}
						if ( false !== $avatar_image_url ) {
							$author_image .= '<img alt="gravatar" src="' . $avatar_image_url . '" />';
						} else {
							$author_image .= '<img alt="mystery person" src="' . plugins_url( 'includes/assets/mystery-person.jpg', dirname( __FILE__ ) ) . '" class="el-mystery-person" />';
						}
					} else {
						$author_image .= '<img alt="mystery person" src="' . plugins_url( 'includes/assets/mystery-person.jpg', dirname( __FILE__ ) ) . '" class="el-mystery-person" />';
					}
					$author_image .= '</div>';
				}

				/*Get Author Name*/
				$author_name = '';
				$name = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-name', true ) );
				if ( '' !== $name ) {
					$author_name = '<div class="el-testimonial-name">
                                    ' . $name . '
                                    </div>';
				}

				/*Get Author Designation*/
				$author_designation = '';
				if ( 'on' === $show_author_designation ) {
					$desgination = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-designation', true ) );
					if ( '' !== $desgination ) {
						$company_name = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-company', true ) );
						if ( 'on' === $show_author_company_name && '' !== $company_name && 'layout3' !== $testimonial_layout ) {
							$author_designation = '<span class="el-testimonial-designation">
	                                                ' . $desgination . ',
	                                                </span>';
						} else {
							$author_designation = '<span class="el-testimonial-designation">
	                                                ' . $desgination . '
	                                                </span>';
						}
					}
				}

				/*Get Company Details*/
				$company_detail = '';
				if ( 'on' === $show_author_company_name ) {
					$company_name = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-company', true ) );
					$company_url  = esc_attr( get_post_meta( $testimonial_id, 'testimonial_meta_box-company_url', true ) );
					if ( '' !== $company_url && '' !== $company_name ) {
						$company_detail = '<span class="el-testimonial-company">
                                                <a href="' . $company_url . '" target="_blank" rel="nofollow">
                                                    ' . $company_name . '
                                                </a>
                                            </span>';
					} elseif ( '' !== $company_name ) {
						$company_detail = '<span class="el-testimonial-company">
                                            ' . $company_name . '
                                            </span>';
					}
				}

				if ( 'on' === $use_masonry && 1 !== $number_of_columns ) {
					$testimonials .= '<div class="el-testimonial-isotope-item">';
				}

				include plugin_dir_path( __FILE__ ) . 'modules/TestimonialExtended/layouts/' . $testimonial_layout . '.php';

				if ( 'on' === $use_masonry && 1 !== $number_of_columns ) {
					$testimonials .= '</div>';
				}
			}

			wp_reset_postdata();

			$data = array(
                'success' => true,
                'items' => $testimonials,
            );
		} else {
			$data = array();
		}

		wp_send_json( $data);
	}

}

new DTE_DiviTestimonialExtended();
